@extends('include.app')



@section('content')


<div class="text-right mb-3">
    <a class="btn btn-primary" href="" data-toggle="modal" data-target="#addcat"  onclick="myFunction()">Add Category
    </a>
</div>


<div class="modal fade" id="addcat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
aria-hidden="true" >
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class=" ">
                    <h5>Create Category</h5>
                </div>
                {{-- <h5 class="modal-title" id="exampleModalLongTitle"></h5> --}}
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

             
                  
                    <div class="">
                        <form action="" method="post" enctype="multipart/form-data" class="add_category" id="addForm" autocomplete="off">
                            @csrf
                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" id="cat_title" name="title" class="form-control" required>
                            </div>
                       
                            <div class="form-group">
                                <label for="file">    <img src="{{ asset('asset/image/default.png') }}" id="defaultimg" height="150" width="150" class="rounded" alt=""></label>
                                <input type="file"  id="file" name="image" class="form-control add_image5" accept="image/x-png,image/jpeg" style="display:none;" required>
                            </div>

                            <style>
                                .info {
                                    background-color: #e7f3fe;
                                    border-left: 6px solid #FB3B03;
                                    padding-left: 10px ;
                                  }
                                  
                                                      </style>
                                                      
                                                      <div class="info">
                                                          <p>Please consider square images of 1:1 ratio for better UI performance in all platforms.</p>
                                                        </div>

                            <div class="form-group text-right">
                                <input class="btn btn-success mr-1" type="submit" id="addcat2" value="Save">
                                <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                            </div>

                        </form>


                    </div>

               

            </div>

        </div>
    </div>
</div>






<div class="card">
    <div class="card-header">
        <h4>Categories</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped" style="width: 100% !important;" id="categorytable">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th >Title</th>
                        <th >Store Count</th>
                        <th >Edit</th>
                        <th >Delete</th>
                    </tr>
                </thead>
                <tbody >

                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="modal fade" id="edit_cat_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Category</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="" method="post" enctype="multipart/form-data"  id="edit_cat" autocomplete="off">

                    @csrf
                    <input type="hidden" class="form-control" id="editcatid" name="id" value="">
       
                    <div class="form-group">
                        <label for="">Title</label>
                        <input type="text" class="form-control" id="editcat_title" name="title"  required>
                    </div>

                 
                    <div class="form-group">
                        <label for="editcat_image"> <img src="" alt="" width="150" height="150" id="editshow_img" class="rounded"></label>
                        <input type="file" class="form-control" id="editcat_image" name="image" accept="image/x-png,image/gif,image/jpeg" style="display: none;" >
                    </div>
<style>
                    .info {
                        background-color: #e7f3fe;
                        border-left: 6px solid #FB3B03;
                        padding-left: 10px ;
                      }
                      
                                          </style>
                                          
                                          <div class="info">
                                              <p>Please consider square images of 1:1 ratio for better UI performance in all platforms.</p>
                                            </div>
                    <div class="form-group text-right">
                        <input type="submit" class=" btn btn-success" id="editcat2">
                        <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>


<script>

function myFunction() {

    $('#addForm')[0].reset();

    $('#defaultimg').attr('src', '{{ asset('asset/image/default.png') }}');
}



var user_type = {{session('user_type')}};


//<!-- edit category -->

$(document).ready(function() {

    $('#categorytable').dataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                "aaSorting": [[ 0, "desc" ]],
                'columnDefs': [{
                    'targets': [0,2,3,4], // column index (start from 0)
                     'orderable': false, 
            
                    /* column index */
                    // 'orderable': false,
                    /* true or false */
                }],
                'ajax': {
                    'url': '{{ route('fetchAllCategory') }}',
                    'data': function(data) {
               
                    }
                }
            });

    
    $("#categorytable").on("click",".edit_cats",function(event) {
        $('#edit_cat')[0].reset();
        var rel_image = $(this).attr('rel');
        var image = `public/storage/${rel_image}`;
        $('#editcat_title').val($(this).data('id'));
        $('#editcatid').val($(this).attr('id'));
        $('#editshow_img').attr('src', image);
        $('#edit_cat_modal').modal('show');
    });
});



// addd image


function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function(e) {
            $('#defaultimg').attr('src', e.target.result);
        }

        reader.readAsDataURL(input.files[0]);
    }
}

$("#file").change(function() {
    readURL(this);
});



            var imageInput = $("#editcat_image");
            imageInput.change(function() {
                if (imageInput[0].files && imageInput[0].files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $('#editshow_img')
                            .attr('src', e.target.result)
                            .width(150)
                            .height(150);
                    };
                    reader.readAsDataURL(imageInput[0].files[0]);
                    console.log(imageInput[0].files[0]);
                }
            })

$(document).ready(function() {

    $(".sideBarli").removeClass("activeLi");
        $(".categoriesSideA").addClass("activeLi");

    $("#edit_cat").submit(function(event) {
        event.preventDefault();
        $('.loader').show();


        if (user_type == "1") {
            

            var formdata = new FormData($("#edit_cat")[0]);
            console.log(formdata);


            $.ajax({
                url: '{{ route('updatecat')}}',
                type: 'POST',
                data: formdata,
                dataType: "json",
                contentType: false,
                cache: false,
                processData: false,
                success: function(response) {
                console.log(response);

                if(response.status == true){
                $('#categorytable').DataTable().ajax.reload(null, false);
                 $('#edit_cat')[0].reset(); 
                $('.loader').hide();
                $('#edit_cat_modal').modal('hide');

                 }
                else{
                    $('.loader').hide();
                    iziToast.error({
                      title: 'Error!',
                      message: 'Category Already Exists',
                      position: 'topRight'
                     });
                }

                },
                error: function(err) {

                    $('.loader').hide();
                
                            console.log(JSON.stringify(err));
                        

                }

            });


        } else {
            $('.loader').hide();
            iziToast.error({
                title: 'Error!',
                message: '  you are a tester  ',
                position: 'topRight'
            });
        }
    });
});


// <!-- add category -->



$("#addForm").submit(function(event) {
    event.preventDefault();
    $('.loader').show();
 

    if (user_type == "1") {

        var formdata = new FormData($("#addForm")[0]);
        console.log(formdata);


        $.ajax({
            url: '{{ route('addcat')}}',
            type: 'POST',
            data: formdata,
            dataType: "json",
            contentType: false,
            cache: false,
            processData: false,
            success: function(response) {
                console.log(response);

                if(response.status == true){
                $('#categorytable').DataTable().ajax.reload(null, false);
                $('.loader').hide();
                $('#addcat').modal('hide');
                    $('#addForm')[0].reset(); 
                
                $('#cat_title').val('');
                $('.add_image5').val('');
                }
                else{
                    $('.loader').hide();
                    iziToast.error({
                      title: 'Error!',
                      message: 'Category Already Exists.',
                      position: 'topRight'
                     });
                }

            },
            error: function(err) {
                $('.loader').hide();
              
                            console.log(JSON.stringify(err));
                        

            }

        });
    } else {

         $('.loader').hide();
        iziToast.error({
            title: 'Error!',
            message: ' you are a tester ',
            position: 'topRight'
        });
    }

});


// <!-- delete category -->

$(document).ready(function() {

    $("#categorytable").on("click",".delete-cat",function(event) {

        event.preventDefault();
        


        swal({
                title: "Are you sure?",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willDelete) => {
                if (willDelete) {
                    swal("Your category has been deleted.", {
                        icon: "success",
                    });

                    if (user_type == "1") {
                        var element = $(this).parent();

                        var cat_id = $(this).attr("rel");
                        var delete_cat_url = "{{route('deleteCat', '')}}"+"/"+cat_id;
            
                        $.getJSON(delete_cat_url).done(function(data) {
                            console.log(data);
                        });

                        $('#categorytable').DataTable().ajax.reload(null, false);
                      
                    } else {
                        iziToast.error({
                            title: 'Error!',
                            message: ' you are a Tester ',
                            position: 'topRight'
                        });
                    }

                } else {
                    swal("Your Category is safe");
                }
            });


    });

});


// $('#addcat').on('hidden.bs.modal', function () {
//     $('#addcat #addForm')[0].reset();
//     });

    
</script>



@endsection
