@extends('include.app')



@section('content')

<style>
    .nav-pills .active {
        background-color: #FFCD0F !important;

    }

    .nav-pills .nav-link {
        color: black !important;
    }

    .total_open_complaint{
        background-color: #FFDA4B !important;
        
        padding: 5px 10px 2px 10px !important;
        margin-bottom: 2px !important;
    }

</style>


<div class="card mt-3">

    <div class="card-header">
        <h4>Order List</h4>
    </div>

    <div class="card-body">


        <div class="tab  " role="tabpanel">
            <ul class="nav nav-pills border-b mb-3  ml-0">

                <li role="presentation" class="nav-item bg-light "><a class="nav-link pointer active" href="#Section1"
                        aria-controls="home" role="tab" data-toggle="tab">All Product <span
                            class="badge badge-transparent total_open_complaint"></span></a>
                </li>

                <li role="presentation" class="nav-item bg-light ml-2 "><a class="nav-link pointer" href="#Section2"
                        role="tab" data-toggle="tab">Out OF Stock Product<span
                            class="badge badge-transparent total_open_complaint"></span></a>
                </li>


               
            </ul>

            <hr>

            <div class="tab-content tabs" id="home">

                <div role="tabpanel" class="tab-pane active" id="Section1">

                    <div class="table-responsive">
                        <table class="table table-striped" id="allProductTable" style="width: 100% !important;">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>name</th>
                                    <th>Unit Price</th>
                                    <th>In Stock </th>
                                    <th width='150'>Category </th>
                                    <th >Action </th>
                                </tr>
                            </thead>
                            <tbody id="">

                            </tbody>
                        </table>
                    </div>
                </div>


                <script >

                    $(document).ready(function () {

                        $('#allProductTable').dataTable({
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            "aaSorting": [
                [0, "desc"]
            ],
            'columnDefs': [{
                'targets': [1,2,3,4], // column index (start from 0)
                'orderable': false,

                /* column index */
                // 'orderable': false,
                /* true or false */
            }],
            'ajax': {
                'url': '{{ route('fetchAllCatProduct') }}',
                'data': {
                    'id':'{{$id}}'
                }
            }
        });
                        
                    });

                </script>


                <div role="tabpanel" class="tab-pane " id="Section2">
                    <div class="table-responsive">
                        <table class="table table-striped" id="outofstocktable" style="width: 100% !important;">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>name</th>
                                    <th>Unit Price</th>
                                    <th>In Stock </th>
                                    <th width='150'>Category </th>
                                    <th width='150'>Action </th>
                                </tr>
                            </thead>
                            <tbody id="">

                            </tbody>
                        </table>
                    </div>
                </div>

                <script >

                    $(document).ready(function () {

                        $('#outofstocktable').dataTable({
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            "aaSorting": [
                [0, "desc"]
            ],
            'columnDefs': [{
                'targets': [1,2,3,4], // column index (start from 0)
                'orderable': false,

                /* column index */
                // 'orderable': false,
                /* true or false */
            }],
            'ajax': {
                'url': '{{ route('fetchAllOfsCatProduct') }}',
                'data': {
                    'id':'{{$id}}'
                }
            }
        });
                        
                    });

                </script>

            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        
    $(".sideBarli").removeClass("activeLi");
        $(".categoriesSideA").addClass("activeLi");
        
        $('#allProductTable').on("change", ".stock", function(event) {

event.preventDefault();


swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your Product Add Out of Stock", {
                icon: "success",
            });

            if (user_type == "1") {



$id = $(this).attr("rel");

if ($(this).prop("checked") == true) {
    swal("Your Product Add In Stock", {
                icon: "success",
            });
    $value = 1;
} else {

    swal("Your Product Add Out Stock", {
                icon: "success",
            });
    console.log("Checkbox is unchecked.");
    $value = 0;
}
$.post('{{ route('updateStock') }}', {
        id: $id,
        stock: $value
    },
    function(returnedData) {
        console.log(returnedData);
        $('#allProductTable').DataTable().ajax.reload(null, false);
        $('#outofstocktable').DataTable().ajax.reload(null, false);
    }).fail(function() {
    console.log("error");
});

    } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are Tester ',
                    position: 'topRight'
                });
            }

        } else {
            $('#allProductTable').DataTable().ajax.reload(null, false);
            $('#outofstocktable').DataTable().ajax.reload(null, false);
            swal("Your Product Not Add Out of Stock");
        }
    });


});


$('#outofstocktable').on("change", ".stock", function(event) {

event.preventDefault();


swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your Product Add In  Stock", {
                icon: "success",
            });

            if (user_type == "1") {



$id = $(this).attr("rel");

if ($(this).prop("checked") == true) {
    $value = 1;
} else {
    console.log("Checkbox is unchecked.");
    $value = 0;
    
}
$.post('{{ route('updateStock') }}', {
        id: $id,
        stock: $value
    },
    function(returnedData) {
        console.log(returnedData);
        $('#allProductTable').DataTable().ajax.reload(null, false);
        $('#outofstocktable').DataTable().ajax.reload(null, false);
    }).fail(function() {
    console.log("error");
});

    } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are Tester ',
                    position: 'topRight'
                });
            }

        } else {
            $('#allProductTable').DataTable().ajax.reload(null, false);
            $('#outofstocktable').DataTable().ajax.reload(null, false);
            swal("Your Product Add In Stock");
        }
    });


});

$("#allProductTable").on("click", ".deleteproduct", function(event) {

event.preventDefault();



swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your Product has Deleted", {
                icon: "success",
            });

            if (user_type == "1") {
                var element = $(this).parent();

                var id = $(this).attr("rel");
                var delete_cat_url = "{{ route('deleteProduct', '') }}" + "/" + id;

                $.getJSON(delete_cat_url).done(function(data) {
                    console.log(data);
                });

                $('#allProductTable').DataTable().ajax.reload(null, false);
                $('#outofstocktable').DataTable().ajax.reload(null, false);

            } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are Tester ',
                    position: 'topRight'
                });
            }

        } else {
            swal("Your Product safe");
        }
    });


});

$("#outofstocktable").on("click", ".deleteproduct", function(event) {

event.preventDefault();



swal({
        title: "Are you sure?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            swal("Your Product has Deleted", {
                icon: "success",
            });

            if (user_type == "1") {
                var element = $(this).parent();

                var id = $(this).attr("rel");
                var delete_cat_url = "{{ route('deleteProduct', '') }}" + "/" + id;

                $.getJSON(delete_cat_url).done(function(data) {
                    console.log(data);
                });

                $('#allProductTable').DataTable().ajax.reload(null, false);
                $('#outofstocktable').DataTable().ajax.reload(null, false);

            } else {
                iziToast.error({
                    title: 'Error!',
                    message: ' you are Tester ',
                    position: 'topRight'
                });
            }

        } else {
            swal("Your Product safe");
        }
    });


});
    });
</script>
    
@endsection