@extends('include.app')


@section('content')

<?php
use Illuminate\Support\Facades\DB;
$settingData = Db::table('shippingcharge')->where('id',1)->first();
    
    $currencies = $settingData->currencies;

?>
    <style>
        .nav-pills .active {
            background-image: linear-gradient(#E66138, #FC3901 ) !important;

        }

        .nav-pills .nav-link {
            color: black !important;
        }

    </style>

    <div class="d-flex   ">

        <div class="card " style="width: 100% !important;">

            <div class=" text-center mt-2">
                <img src="{{env('image')}}public/storage/{{ $data['image'] }}" class="rounded-circle" height="170"
                    width="170" alt="">
                <h4 class="text-dark mt-2">{{ $data['username'] }}</h4>
                <h6>{{ $data['fullname'] }}</h6>
                <h6>{{ $data['number'] }}</h6>


            </div>

        </div>

        <div class="card ml-3" style="width: 100% !important; height:fit-content;">
            <div class="card-header">
                <h4>Payment Details</h4>
            </div>
            <div class="card-body">
                <h6 class="card-title text-dark " style="font-weight: lighter;">Delivery Boy Amount to Pay :</h6>
                <p class="card-text">{{$currencies}} {{ $data['payment'] }} </p>

                <button class="btn btn-danger" rel="{{ $data['id'] }}" id="paymentResolve">Payment Resolve </button>
            </div>

        </div>
    </div>

    <script>
        $(document).ready(function() {
            $(document).on("click", "#paymentResolve", function(event) {

                event.preventDefault();



                swal({
                        title: "Are you sure?",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            swal("Your Payment has Resolve", {
                                icon: "success",
                            });

                            if (user_type == "1") {
                                var element = $(this).parent();

                                var id = $(this).attr("rel");
                                var delete_cat_url = "{{ route('updatePayment', '') }}" + "/" + id;

                                $.getJSON(delete_cat_url).done(function(data) {
                                    console.log(data);
                                });

                                location.reload();

                            } else {
                                iziToast.error({
                                    title: 'Error!',
                                    message: ' you are Tester ',
                                    position: 'topRight'
                                });
                            }

                        } else {
                            swal("Your payment Not Resolve ");
                        }
                    });


            });
        });

    </script>


    <div class="card mt-3">

        <div class="card-header">
            <h4>Order List</h4>
        </div>

        <div class="card-body">


            <div class="tab  " role="tabpanel">
                <ul class="nav nav-pills border-b mb-3  ml-0">


                    <li role="presentation" class="nav-item bg-light  "><a class="nav-link active pointer" href="#Section1"
                            role="tab" data-toggle="tab">Completed Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>

                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section2"
                            role="tab" data-toggle="tab">Confirmed Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>


                    <li role="presentation" class="nav-item bg-light ml-2"><a class="nav-link pointer" href="#Section3"
                            role="tab" data-toggle="tab">On Hold Orders<span
                                class="badge badge-transparent total_open_complaint"></span></a>
                    </li>




                </ul>

                <hr>

                <div class="tab-content tabs" id="home">

                    <div role="tabpanel" class="tab-pane active" id="Section1">

                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="dbCompleteOrderTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Area</th>
                                        <th>Total</th>
                                        <th>Payment Type</th>
                                        <th>Status</th>
                                        <th>Order Date</th>
                                        <th>Completed At</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <script>
                        $(document).ready(function() {

                            $('#dbCompleteOrderTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllDeliveryBoyCompletedOrder') }}',
                                    "data": {
                                             "dbid": '{{$data['id']}}'
                                      },
                                      error:(e)=>{console.log(e)}
                                }
                            });

                        });

                    </script>


                    <div role="tabpanel" class="tab-pane " id="Section2">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="cofirmorderTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Area</th>
                                        <th>Total</th>
                                        <th>Payment Type</th>
                                        <th>Status</th>
                                        <th>Order Date</th>


                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <script>
                        $(document).ready(function() {

                            $('#cofirmorderTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllDeliveryBoyConfirmOrder') }}',
                                    "data": {
                                             "dbid": '{{$data['id']}}'
                                      }
                                }
                            });

                        });

                    </script>

                    <div role="tabpanel" class="tab-pane " id="Section3">
                        <div class="table-responsive">
                            <table class="table table-striped" style="width: 100% !important;" id="holdOrderTable">
                                <thead>
                                    <tr>
                                        <th>Order Id</th>
                                        <th>Username</th>
                                        <th>Area</th>
                                        <th>Total</th>
                                        <th>Reason</th>
                                        <th>Status</th>
                                        <th>Order Date</th>

                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <script>
                        $(document).ready(function() {

                            $(".sideBarli").removeClass("activeLi");
            $(".deliveryBoySideA").addClass("activeLi");
                            $('#holdOrderTable').dataTable({
                                'processing': true,
                                'serverSide': true,
                                'serverMethod': 'post',
                                "aaSorting": [
                                    [0, "desc"]
                                ],
                                'columnDefs': [{
                                    'targets': [1, 2, 3, 4, 5, 6], // column index (start from 0)
                                    'orderable': false,

                                    /* column index */
                                    // 'orderable': false,
                                    /* true or false */
                                }],
                                'ajax': {
                                    'url': '{{ route('fetchAllDeliveryBoyHoldOrder') }}',
                                    "data": {
                                             "dbid": '{{$data['id']}}'
                                      }
                                }
                            });

                        });

                    </script>

                </div>
            </div>
        </div>
    </div>

@endsection
