@extends('include.app')


@section('content')

<?php
use Illuminate\Support\Facades\DB;
$settingData = Db::table('shippingcharge')->where('id',1)->first();
    
    $currencies = $settingData->currencies;

?>

    <div class="section-body">
        <div class="invoice">
            <div class="invoice-print">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="invoice-title">
                            <h2>View Order</h2>
                            <div class="invoice-number">Order {{$data['order_id']}}</div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <address>


                                    
                               
                                    <?php 
                                    if($data['dbname'] != null)
                                    {
                                        echo "     <strong>Assign To:</strong><br>";
                                    echo $data['dbname'];
                                    echo "<br>";
                                    echo $data['dbnumber'];
                                    }

                                   ?>
                                </address>
                            </div>
                            <div class="col-md-6 text-md-right">
                                <address>
                                    <strong>Shipped To:
                                        
                                    </strong><br>
                                    {{$data['orderaddress']['firstname']}} {{$data['orderaddress']['lastname']}} <br>
                                    {{$data['orderaddress']['address']}},<br>  {{$data['orderaddress']['landmark']}}, <br>
                                    {{$data['orderaddress']['area']}} , {{$data['orderaddress']['city']}}.<br>
                                    {{$data['orderaddress']['pincode']}} 
                                </address>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <address>
                                    <strong>Payment Method:</strong><br>
                                   <?php if($data['payment_type'] == 1){echo "Cash On Delivery";}else {
                                       echo 'Card Delivery';
                                   } ?><br>
                                </address>
                            </div>
                            <div class="col-md-6 text-md-right">
                                <address>
                                    <strong>Order Date:</strong><br>
                                    {{  $data['created_at']->format('d M Y g:i A') }}<br><br>
                                </address>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="section-title">Order Summary</div>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-md">
                                <tbody>
                                    <tr>
                                        <th data-width="40" style="width: 40px;">#</th>
                                        <th >Image</th>
                                        <th>Item</th>
                                        <th class="text-center">Unit</th>
                                        <th class="text-center">Price</th>
                                        <th class="text-center">Quantity</th>
                                        <th class="text-right">Totals</th>
                                    </tr>
                                    
                                    <?php $i = 1; ?>
                                        @foreach ( $data['orderproducts'] as  $result)

                                       
                                       <tr>
                                        {{-- public/storage/uploads/4jvfFAkkfe5nr5EhsMSOZRGidgxaBsCVhfbtB7Eh.jpg --}}
                                        <td>{{$i}}</td>
                                        <td><img src="{{env('image')}}public/storage/{{$result['image']}}" height="50" width="50" alt=""></td>
                                        <td>{{$result['product_name']}}</td>
                                        <td class="text-center">{{$result['price_unit']}} {{$result['price_unit_name']}}</td>
                                        <td class="text-center">{{$currencies}} {{$result['price']}} </td>
                                        <td class="text-center">{{$result['quantity']}}</td>

                                    
                                        <td class="text-right">{{$currencies}} {{ $result['total_price']}} </td>

                                        <?php $i++; ?>
                                          
                                    </tr>
                                            
                                        @endforeach
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-8">
                            </div>
                            <div class="col-lg-4 text-right">
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">Subtotal</div>
                                    <div class="invoice-detail-value">{{$currencies}} {{$data['subtotal']}} </div>
                                </div>
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">Shipping</div>
                                    <div class="invoice-detail-value">{{$currencies}} {{$data['shipping_charge']}} </div>
                                </div>
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">Coupon Discount</div>
                                    <div class="invoice-detail-value">{{$currencies}} {{$data['coupon_discount']}} </div>
                                </div>
                                <hr class="mt-2 mb-2">
                                <div class="invoice-detail-item">
                                    <div class="invoice-detail-name">Total</div>
                                    <div class="invoice-detail-value invoice-detail-value-lg">{{$currencies}} {{$data['total_amount']}} </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <?php 
            if($data['reason'] != ""){

            //   echo $data['reason'];
                         echo  '<div class="form-group ">
                        <label for="product_description">Hold Reason</label>
                        <textarea name="" id="" cols="30" rows="10"class="form-control" readonly>'.$data['reason'].'</textarea >

                    </div>';
              
            }
          ?>
            <div class="text-md-right pb-5">
                <div class="float-lg-left mb-lg-0 mb-3">

                    <?php 
                    if($data['status']  == 1 || $data['status'] == 3)
                    {
                    
                    echo "<a href='' data-toggle='modal' data-target='#deliveryBoyModal' class='btn text-white btn-primary  confirmOrder'><i class='fas fa-truck'></i> Start Delivery</a>";
                   
                    }
                    ?>
              
                    <a href="{{route('orders')}}"
                        class="btn btn-danger btn-icon icon-left text-white"><i class="fas fa-arrow-left"></i> Back</a>
                </div>
            </div>

           
        </div>
    </div>

    <div class="modal fade" id="deliveryBoyModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                   <h5 class="modal-title">Add Delivery Boy </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
   
                <form action="" method="POST" id="deliveryfrom" >
                <div class="modal-body">
                 
                    <input type="hidden" name="id" class="id">
                   <div class="form-group ">
                       <label>&nbsp;</label>
                       <select class="form-control select_delivery" name="deliveryBoy_id" required>
   
                           <option disabled selected value="">Select</option>
   
                       </select>
                   </div>
                </div>
                <div class="modal-footer">
                   <div class="form-group text-right">
                       <input type="submit" class=" btn btn-success" value="Confirm">
                       <a href="#" class="btn btn-light text-dark" data-dismiss="modal" aria-label="Close">Close</a>
                   </div>
                </div>
               </form>
            </div>
        </div>
    </div>
   
    <script >
      $(".sideBarli").removeClass("activeLi");
            $(".ordersSideA").addClass("activeLi");
   $(document).on("click",".confirmOrder",function(event) {
   
   
           $('.id').val('{{$data['id']}}');
   
   
   
       $.getJSON("{{ route('getDelivryBoy') }}").done(function(data) {
   
   $('.select_delivery option').remove();
   $('.select_delivery').html( '<option disabled selected value="">Select</option>');
   
           $.each(data.boys, function(index, item) {
               var element;
               var parent = $('.select_delivery');
   
   
   
               element = `
                               <option value="${item.id}">${item.username}</option>`;
   
               parent.append(element);
   
   
           });
    
      });
   
      $("#deliveryfrom").submit(function(event) {
       event.preventDefault();
       $('.loader').show();
    
   
       if (user_type == "1") {
   
           var formdata = new FormData($("#deliveryfrom")[0]);
           console.log(formdata);
   
   
           $.ajax({
               url: '{{ route('confirmOrder')}}',
               type: 'POST',
               data: formdata,
               dataType: "json",
               contentType: false,
               cache: false,
               processData: false,
               success: function(response) {
                   console.log(response);
   
                   if(response.status == true){
         
                   $('.loader').hide();
                   $('#deliveryBoyModal').modal('hide');
                   
                   iziToast.success({
                         title: 'success!',
                         message: 'Confirm Order Successfull',
                         position: 'topRight'
                        });

                     location.reload();   
                  
                   }
                   
   
               },
               error: function(err) {
                   $('.loader').hide();
                 
                               console.log(JSON.stringify(err));
                           
   
               }
   
           });
       } else {
   
            $('.loader').hide();
           iziToast.error({
               title: 'Error!',
               message: ' you are Tester ',
               position: 'topRight'
           });
       }
   
   });
   
   
   
   });
    </script>
@endsection
