@extends('include.app')

@section('nav')
<li class="menu-header text-white">Main</li>
<li class=" activeLi ">
    <a href="{{ route('index') }}" class="nav-link text-white "><i
            class="fas fa-tachometer-alt pt-1"></i><span>Dashboard</span></a>
</li>

<li class=" ">
    <a href="{{ route('users') }}" class="nav-link"><i
            class="fas fa-users"></i></i><span>Users</span></a>
</li>

<li class="menu-header text-white">Product</li>



<li class="">
    <a href="{{ route('categories') }}" class="nav-link "><i
            class="fab fa-cuttlefish"></i><span>Category</span></a>
</li>

<li class="">
    <a href="{{ route('units') }}" class="nav-link "><i
            class="fab fa-uniregistry"></i><span>Unit</span></a>
</li>


<li class="">
    <a href="{{ route('product') }}" class="nav-link "><i
            class="fas fa-shopping-cart"></i><span>Product</span></a>
</li>





<li class="dropdown">
    <a href="{{ route('coupons') }}"><i class="fas fa-gift"></i><span>Coupan</span></a>
</li>
<li class="menu-header text-white">ORDERS</li>

<li class="dropdown">
    <a href="{{ route('orders') }}"><i class="fab fa-jedi-order"></i><span>Orders </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('deliveryBoy') }}"><i class="fas fa-child"></i><span>Delivery Boy
        </span></a>
</li>
<li class="dropdown">
    <a href="{{ route('complaints') }}"><i class="fas fa-comment-alt"></i><span>Complaint
        </span></a>
</li>

<li class="dropdown">
    <a href="{{ route('reviews') }}"><i class="fas fa-star"></i><span>Review And Rating
        </span></a>
</li>
<li class="menu-header text-white">Setting</li>

<li class="">
    <a href="{{ route('banners') }}" class="nav-link "><i
            class="fas fa-image"></i><span>Banner</span></a>
</li>

<li class="">
    <a href="{{ route('faqs') }}" class="nav-link "><i
            class="fas fa-question-circle"></i><span>FAQ</span></a>
</li>

<li class="">
    <a href="{{ route('address') }}" class="nav-link "><i
            class="fas fa-map"></i><span>Address</span></a>
</li>

<li class="">
    <a href="{{ route('notification') }}" class="nav-link "><i
            class="fas fa-bell"></i><span>NotifiCation</span></a>
</li>

<li class="">
    <a href="{{ route('setting') }}" class="nav-link "><i class="fas fa-cog"></i><span>Other
            Setting</span></a>
</li>


@endsection

@section('content')


    <style>
        .chartjs-render-monitor {
            -webkit-animation: chartjs-render-animation 0.001s;
            animation: chartjs-render-animation 0.001s;
        }

        *,
        ::after,
        ::before {
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        .mainbg {
            background-image: linear-gradient(#E66138, #FC3901 ) !important;
        }

        .card-icon2 {
            width: 50px;
            height: 50px;
            line-height: 50px;
            font-size: 22px;
            margin: 25px 65px;
            box-shadow: 5px 3px 10px 0 rgb(21 15 15 / 30%);
            border-radius: 10px;
            background: #6777ef;

            text-align: center;
        }

        i {
            font-size: 20px !important;
        }

.maincolor{
    color: white !important;
}
    </style>

    <?php
    use Illuminate\Support\Facades\DB;
    use Carbon\Carbon;

    $todayCount = DB::table('orderdetails')
    ->whereDate('created_at', Carbon::today())
    ->count();
    $todayAmount = DB::table('orderdetails')
    ->whereDate('created_at', Carbon::today())
    ->sum('total_amount');
    $monthCount = DB::table('orderdetails')
    ->whereMonth('created_at', date('m'))
    ->count();
    $monthAmount = DB::table('orderdetails')
    ->whereMonth('created_at', date('m'))
    ->sum('total_amount');
    $YearCount = DB::table('orderdetails')
    ->whereYear('created_at', date('Y'))
    ->count();
    $YearAmount = DB::table('orderdetails')
    ->whereYear('created_at', date('Y'))
    ->sum('total_amount');
    $AllCount = DB::table('orderdetails')->count();
    $AllAmount = DB::table('orderdetails')->sum('total_amount');

    $proCount = DB::table('orderdetails')
    ->where('status', 1)
    ->count();
    $confirmCount = DB::table('orderdetails')
    ->where('status', 2)
    ->count();
    $holdCount = DB::table('orderdetails')
    ->where('status', 3)
    ->count();
    $cancelCount = DB::table('orderdetails')
    ->where('status', 5)
    ->count();

    $proAmount = DB::table('orderdetails')
    ->where('status', 1)
    ->sum('total_amount');
    $confirmAmount = DB::table('orderdetails')
    ->where('status', 2)
    ->sum('total_amount');
    $holdAmount = DB::table('orderdetails')
    ->where('status', 3)
    ->sum('total_amount');
    $cancelAmount = DB::table('orderdetails')
    ->where('status', 5)
    ->sum('total_amount');

    $category = DB::table('category')->count();
    $product = DB::table('product')->count();
    $ofsproduct = DB::table('product')
    ->where('stock', 0)
    ->count();

    $dbboycount = DB::table('deliveryboy')->count();
    $dbpayment = DB::table('deliveryboy')->sum('payment');
    $opcomplaint = DB::table('complaint')
    ->where('status', 0)
    ->count();
    ?>

    {{-- <img src="" alt=""> --}}
    <section class="section">
        <div class="row">
            <div class="col-md-12">
                <h4> Orders</h4>
            </div>
        </div>
        <div class="row ">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card ">
                    <div class="card-statistic-4 ">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">Today</h5>
                                        <h2 class="mb-3 font-18">{{ $todayCount }}</h2>
                                        <p class="mb-0"><span class="col-green">₹{{ $todayAmount }}</span></p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-calendar-alt maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15"> This Month</h5>
                                        <h2 class="mb-3 font-18 ">{{ $monthCount }}</h2>
                                        <p class="mb-0"><span class="col-orange">₹ {{ $monthAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-calendar-alt maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">This Year</h5>
                                        <h2 class="mb-3 font-18">{{ $YearCount }}</h2>
                                        <p class="mb-0"><span class="col-green">₹ {{ $YearAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-calendar-alt maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">All Time</h5>
                                        <h2 class="mb-3 font-18">{{ $AllCount }}</h2>
                                        <p class="mb-0"><span class="col-green">₹ {{ $AllAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-calendar-alt maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4>Orders</h4>
            </div>
        </div>


        <div class="row ">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">Processing</h5>
                                        <h2 class="mb-3 font-18">{{ $proCount }}</h2>
                                        <p class="mb-0"><span class="col-green">₹ {{ $proAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-chart-line maincolor" style="color:black;"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15"> Confirmed</h5>
                                        <h2 class="mb-3 font-18"> {{ $confirmCount }}</h2>
                                        <p class="mb-0"><span class="col-orange">₹ {{ $confirmAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-check maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">On Hold</h5>
                                        <h2 class="mb-3 font-18"> {{ $holdCount }}</h2>
                                        <p class="mb-0"><span class="col-dark">₹ {{ $holdAmount }}</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-pause maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="align-items-center justify-content-between">
                            <div class="row ">
                                <div class="col-lg-5 col-md-5 col-sm-5 col-xs-5 pr-0 pt-3">
                                    <div class="card-content">
                                        <h5 class="font-15">Cancelled</h5>
                                        <h2 class="mb-3 font-18"> {{ $cancelCount }}</h2>
                                        <p class="mb-0"><span class="col-green">₹ {{ $cancelAmount }}</span> </p>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                    <div class="card-icon2 mainbg">
                                        <i class="fas fa-times maincolor"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4>Products</h4>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="fas fa-boxes maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Categories</h4>
                        </div>
                        <div class="card-body pull-right">
                            {{ $category }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-1" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="fas fa-box maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Products</h4>
                        </div>
                        <div class="card-body pull-right">
                            {{ $product }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-2" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="fas fa-box-open maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Out of Stock Products</h4>
                        </div>
                        <div class="card-body pull-right">
                            {{ $ofsproduct }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-3" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <h4>Miscellaneous</h4>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="fas fa-users maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Delivery Boys</h4>
                        </div>
                        <div class="card-body pull-right">
                            {{ $dbboycount }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-4" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="fas fa-rupee-sign maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Total Delivery Boy Payment</h4>
                        </div>
                        <div class="card-body pull-right">
                            ₹ {{ $dbpayment }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-5" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-icon shadow-primary mainbg">
                        <i class="far fa-comment-alt maincolor"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4 class="pull-right">Open Complaints</h4>
                        </div>
                        <div class="card-body pull-right">
                            {{ $opcomplaint }}
                        </div>
                    </div>
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                            style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="chart-6" height="79" width="336" style="display: block; width: 336px; height: 79px;"
                            class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </section>





@endsection
